/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.ccache.CCacheOutputStream;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PrincipalName
implements Cloneable {
    public static final int KRB_NT_UNKNOWN = 0;
    public static final int KRB_NT_PRINCIPAL = 1;
    public static final int KRB_NT_SRV_INST = 2;
    public static final int KRB_NT_SRV_HST = 3;
    public static final int KRB_NT_SRV_XHST = 4;
    public static final int KRB_NT_UID = 5;
    public static final String TGS_DEFAULT_SRV_NAME = "krbtgt";
    public static final int TGS_DEFAULT_NT = 2;
    public static final char NAME_COMPONENT_SEPARATOR = '/';
    public static final char NAME_REALM_SEPARATOR = '@';
    public static final char REALM_COMPONENT_SEPARATOR = '.';
    public static final String NAME_COMPONENT_SEPARATOR_STR = "/";
    public static final String NAME_REALM_SEPARATOR_STR = "@";
    public static final String REALM_COMPONENT_SEPARATOR_STR = ".";
    private int nameType;
    private String[] nameStrings;
    private Realm nameRealm;
    private String salt = null;

    protected PrincipalName() {
    }

    public PrincipalName(String[] stringArray, int n) throws IllegalArgumentException, IOException {
        if (stringArray == null) {
            throw new IllegalArgumentException("Null input not allowed");
        }
        this.nameStrings = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.nameStrings, 0, stringArray.length);
        this.nameType = n;
        this.nameRealm = null;
    }

    public PrincipalName(String[] stringArray) throws IOException {
        this(stringArray, 0);
    }

    public Object clone() {
        try {
            PrincipalName principalName = (PrincipalName)super.clone();
            if (this.nameStrings != null) {
                principalName.nameStrings = (String[])this.nameStrings.clone();
            }
            if (this.nameRealm != null) {
                principalName.nameRealm = (Realm)this.nameRealm.clone();
            }
            return principalName;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)"Should never happen");
        }
    }

    public boolean equals(Object object) {
        if (object instanceof PrincipalName) {
            return this.equals((PrincipalName)object);
        }
        return false;
    }

    public boolean equals(PrincipalName principalName) {
        if (!this.equalsWithoutRealm(principalName)) {
            return false;
        }
        if (this.nameRealm != null && principalName.nameRealm == null || this.nameRealm == null && principalName.nameRealm != null) {
            return false;
        }
        return this.nameRealm == null || principalName.nameRealm == null || this.nameRealm.equals(principalName.nameRealm);
    }

    boolean equalsWithoutRealm(PrincipalName principalName) {
        if (this.nameStrings != null && principalName.nameStrings == null || this.nameStrings == null && principalName.nameStrings != null) {
            return false;
        }
        if (this.nameStrings != null && principalName.nameStrings != null) {
            if (this.nameStrings.length != principalName.nameStrings.length) {
                return false;
            }
            for (int i = 0; i < this.nameStrings.length; ++i) {
                if (this.nameStrings[i].equals(principalName.nameStrings[i])) continue;
                return false;
            }
        }
        return true;
    }

    public PrincipalName(DerValue derValue) throws Asn1Exception, IOException {
        this.nameRealm = null;
        if (derValue == null) {
            throw new IllegalArgumentException("Null input not allowed");
        }
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        Object object = derValue2.getData().getBigInteger();
        this.nameType = ((BigInteger)object).intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) == 1) {
            object = derValue2.getData().getDerValue();
            if (((DerValue)object).getTag() != 48) {
                throw new Asn1Exception(906);
            }
            Vector<String> vector = new Vector<String>();
            while (((DerValue)object).getData().available() > 0) {
                DerValue derValue3 = ((DerValue)object).getData().getDerValue();
                vector.addElement(new KerberosString(derValue3).toString());
            }
            if (vector.size() > 0) {
                this.nameStrings = new String[vector.size()];
                vector.copyInto(this.nameStrings);
            } else {
                this.nameStrings = new String[]{""};
            }
        } else {
            throw new Asn1Exception(906);
        }
    }

    public static PrincipalName parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new PrincipalName(derValue2);
    }

    protected static String[] parseName(String string) {
        String string2;
        Vector<String> vector = new Vector<String>();
        String string3 = string;
        int n = 0;
        int n2 = 0;
        while (n < string3.length()) {
            if (string3.charAt(n) == '/') {
                if (n > 0 && string3.charAt(n - 1) == '\\') {
                    string3 = string3.substring(0, n - 1) + string3.substring(n, string3.length());
                    continue;
                }
                if (n2 < n) {
                    string2 = string3.substring(n2, n);
                    vector.addElement(string2);
                }
                n2 = n + 1;
            } else if (string3.charAt(n) == '@') {
                if (n > 0 && string3.charAt(n - 1) == '\\') {
                    string3 = string3.substring(0, n - 1) + string3.substring(n, string3.length());
                    continue;
                }
                if (n2 < n) {
                    string2 = string3.substring(n2, n);
                    vector.addElement(string2);
                }
                n2 = n + 1;
                break;
            }
            ++n;
        }
        if (n == string3.length() && n2 < n) {
            string2 = string3.substring(n2, n);
            vector.addElement(string2);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public PrincipalName(String string, int n) throws RealmException {
        Object object;
        if (string == null) {
            throw new IllegalArgumentException("Null name not allowed");
        }
        String[] stringArray = PrincipalName.parseName(string);
        Realm realm = null;
        String string2 = Realm.parseRealmAtSeparator(string);
        if (string2 == null) {
            try {
                object = Config.getInstance();
                string2 = ((Config)object).getDefaultRealm();
            }
            catch (KrbException krbException) {
                RealmException realmException = new RealmException(krbException.getMessage());
                realmException.initCause(krbException);
                throw realmException;
            }
        }
        if (string2 != null) {
            realm = new Realm(string2);
        }
        switch (n) {
            case 3: {
                if (stringArray.length >= 2) {
                    object = stringArray[1];
                    try {
                        String string3 = InetAddress.getByName((String)object).getCanonicalHostName();
                        if (string3.toLowerCase().startsWith(((String)object).toLowerCase() + REALM_COMPONENT_SEPARATOR_STR)) {
                            object = string3;
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    stringArray[1] = ((String)object).toLowerCase();
                }
                this.nameStrings = stringArray;
                this.nameType = n;
                object = PrincipalName.mapHostToRealm(stringArray[1]);
                if (object != null) {
                    this.nameRealm = new Realm((String)object);
                    break;
                }
                this.nameRealm = realm;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                this.nameStrings = stringArray;
                this.nameType = n;
                this.nameRealm = realm;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal name type");
            }
        }
    }

    public PrincipalName(String string) throws RealmException {
        this(string, 0);
    }

    public PrincipalName(String string, String string2) throws RealmException {
        this(string, 0);
        this.nameRealm = new Realm(string2);
    }

    public String getRealmAsString() {
        return this.getRealmString();
    }

    public String getPrincipalNameAsString() {
        StringBuffer stringBuffer = new StringBuffer(this.nameStrings[0]);
        for (int i = 1; i < this.nameStrings.length; ++i) {
            stringBuffer.append(this.nameStrings[i]);
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getName() {
        return this.toString();
    }

    public int getNameType() {
        return this.nameType;
    }

    public String[] getNameStrings() {
        return (String[])this.nameStrings.clone();
    }

    public byte[][] toByteArray() {
        byte[][] byArrayArray = new byte[this.nameStrings.length][];
        for (int i = 0; i < this.nameStrings.length; ++i) {
            byArrayArray[i] = new byte[this.nameStrings[i].length()];
            byArrayArray[i] = this.nameStrings[i].getBytes();
        }
        return byArrayArray;
    }

    public String getRealmString() {
        if (this.nameRealm != null) {
            return this.nameRealm.toString();
        }
        return null;
    }

    public Realm getRealm() {
        return this.nameRealm;
    }

    public void setRealm(Realm realm) throws RealmException {
        this.nameRealm = realm;
    }

    public void setRealm(String string) throws RealmException {
        this.nameRealm = new Realm(string);
    }

    public String getSalt() {
        if (this.salt == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.nameRealm != null) {
                stringBuffer.append(this.nameRealm.toString());
            }
            for (int i = 0; i < this.nameStrings.length; ++i) {
                stringBuffer.append(this.nameStrings[i]);
            }
            return stringBuffer.toString();
        }
        return this.salt;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nameStrings.length; ++i) {
            if (i > 0) {
                stringBuffer.append(NAME_COMPONENT_SEPARATOR_STR);
            }
            stringBuffer.append(this.nameStrings[i]);
        }
        if (this.nameRealm != null) {
            stringBuffer.append(NAME_REALM_SEPARATOR_STR);
            stringBuffer.append(this.nameRealm.toString());
        }
        return stringBuffer.toString();
    }

    public String getNameString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nameStrings.length; ++i) {
            if (i > 0) {
                stringBuffer.append(NAME_COMPONENT_SEPARATOR_STR);
            }
            stringBuffer.append(this.nameStrings[i]);
        }
        return stringBuffer.toString();
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        BigInteger bigInteger = BigInteger.valueOf(this.nameType);
        derOutputStream2.putInteger(bigInteger);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        DerValue[] derValueArray = new DerValue[this.nameStrings.length];
        for (int i = 0; i < this.nameStrings.length; ++i) {
            derValueArray[i] = new KerberosString(this.nameStrings[i]).toDerValue();
        }
        derOutputStream2.putSequence(derValueArray);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public boolean match(PrincipalName principalName) {
        boolean bl = true;
        if (this.nameRealm != null && principalName.nameRealm != null && !this.nameRealm.toString().equalsIgnoreCase(principalName.nameRealm.toString())) {
            bl = false;
        }
        if (this.nameStrings.length != principalName.nameStrings.length) {
            bl = false;
        } else {
            for (int i = 0; i < this.nameStrings.length; ++i) {
                if (this.nameStrings[i].equalsIgnoreCase(principalName.nameStrings[i])) continue;
                bl = false;
            }
        }
        return bl;
    }

    public void writePrincipal(CCacheOutputStream cCacheOutputStream) throws IOException {
        byte[] byArray;
        cCacheOutputStream.write32(this.nameType);
        cCacheOutputStream.write32(this.nameStrings.length);
        if (this.nameRealm != null) {
            byArray = null;
            byArray = this.nameRealm.toString().getBytes();
            cCacheOutputStream.write32(byArray.length);
            cCacheOutputStream.write(byArray, 0, byArray.length);
        }
        byArray = null;
        for (int i = 0; i < this.nameStrings.length; ++i) {
            byArray = this.nameStrings[i].getBytes();
            cCacheOutputStream.write32(byArray.length);
            cCacheOutputStream.write(byArray, 0, byArray.length);
        }
    }

    protected PrincipalName(String string, String string2, String string3, int n) throws KrbException {
        if (n != 2) {
            throw new KrbException(60, "Bad name type");
        }
        String[] stringArray = new String[]{string, string2};
        this.nameStrings = stringArray;
        this.nameRealm = new Realm(string3);
        this.nameType = n;
    }

    public String getInstanceComponent() {
        if (this.nameStrings != null && this.nameStrings.length >= 2) {
            return new String(this.nameStrings[1]);
        }
        return null;
    }

    static String mapHostToRealm(String string) {
        String string2 = null;
        try {
            String string3 = null;
            Config config = Config.getInstance();
            string2 = config.getDefault(string, "domain_realm");
            if (string2 != null) {
                return string2;
            }
            for (int i = 1; i < string.length() && (string.charAt(i) != '.' || i == string.length() - 1 || (string2 = config.getDefault(string3 = string.substring(i), "domain_realm")) == null && (string2 = config.getDefault(string3 = string.substring(i + 1), "domain_realm")) == null); ++i) {
            }
        }
        catch (KrbException krbException) {
            // empty catch block
        }
        return string2;
    }
}

