/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.FunctionCall;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;
import sun.org.mozilla.javascript.internal.ast.ObjectLiteral;

public class NewExpression
extends FunctionCall {
    private ObjectLiteral initializer;

    public NewExpression() {
        this.type = 30;
    }

    public NewExpression(int n) {
        super(n);
        this.type = 30;
    }

    public NewExpression(int n, int n2) {
        super(n, n2);
        this.type = 30;
    }

    public ObjectLiteral getInitializer() {
        return this.initializer;
    }

    public void setInitializer(ObjectLiteral objectLiteral) {
        this.initializer = objectLiteral;
        if (objectLiteral != null) {
            objectLiteral.setParent(this);
        }
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("new ");
        stringBuilder.append(this.target.toSource(0));
        stringBuilder.append("(");
        if (this.arguments != null) {
            this.printList(this.arguments, stringBuilder);
        }
        stringBuilder.append(")");
        if (this.initializer != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.initializer.toSource(0));
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.target.visit(nodeVisitor);
            for (AstNode astNode : this.getArguments()) {
                astNode.visit(nodeVisitor);
            }
            if (this.initializer != null) {
                this.initializer.visit(nodeVisitor);
            }
        }
    }
}

