/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public abstract class Pool<T> {
    private volatile WeakReference<ConcurrentLinkedQueue<T>> queue;

    public final T take() {
        T t = this.getQueue().poll();
        if (t == null) {
            return this.create();
        }
        return t;
    }

    private ConcurrentLinkedQueue<T> getQueue() {
        ConcurrentLinkedQueue concurrentLinkedQueue;
        WeakReference<ConcurrentLinkedQueue<T>> weakReference = this.queue;
        if (weakReference != null && (concurrentLinkedQueue = (ConcurrentLinkedQueue)weakReference.get()) != null) {
            return concurrentLinkedQueue;
        }
        concurrentLinkedQueue = new ConcurrentLinkedQueue();
        this.queue = new WeakReference(concurrentLinkedQueue);
        return concurrentLinkedQueue;
    }

    public final void recycle(T t) {
        this.getQueue().offer(t);
    }

    protected abstract T create();

    public static final class Marshaller
    extends Pool<javax.xml.bind.Marshaller> {
        private final JAXBContext context;

        public Marshaller(JAXBContext jAXBContext) {
            this.context = jAXBContext;
        }

        @Override
        protected javax.xml.bind.Marshaller create() {
            try {
                return this.context.createMarshaller();
            }
            catch (JAXBException jAXBException) {
                throw new AssertionError((Object)jAXBException);
            }
        }
    }

    public static final class TubePool
    extends Pool<Tube> {
        private final Tube master;

        public TubePool(Tube tube) {
            this.master = tube;
            this.recycle(tube);
        }

        @Override
        protected Tube create() {
            return TubeCloner.clone(this.master);
        }
    }

    public static final class Unmarshaller
    extends Pool<javax.xml.bind.Unmarshaller> {
        private final JAXBContext context;

        public Unmarshaller(JAXBContext jAXBContext) {
            this.context = jAXBContext;
        }

        @Override
        protected javax.xml.bind.Unmarshaller create() {
            try {
                return this.context.createUnmarshaller();
            }
            catch (JAXBException jAXBException) {
                throw new AssertionError((Object)jAXBException);
            }
        }
    }
}

