/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.TouchInputSupport;
import com.sun.glass.ui.View;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class MacTouchInputSupport
extends TouchInputSupport {
    private final Map<Long, WeakReference<View>> touchIdToView = new HashMap<Long, WeakReference<View>>();
    private int curModifiers;
    private boolean curIsDirect;
    private List<TouchPoint> curTouchPoints;

    MacTouchInputSupport(TouchInputSupport.TouchCountListener touchCountListener, boolean bl) {
        super(touchCountListener, bl);
    }

    public void notifyBeginTouchEvent(View view, int n, boolean bl, int n2) {
        this.curModifiers = n;
        this.curIsDirect = bl;
        this.curTouchPoints = new ArrayList<TouchPoint>(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEndTouchEvent(View view) {
        if (this.curTouchPoints.isEmpty()) {
            return;
        }
        try {
            super.notifyBeginTouchEvent(view, this.curModifiers, this.curIsDirect, this.curTouchPoints.size());
            for (TouchPoint touchPoint : this.curTouchPoints) {
                super.notifyNextTouchEvent(view, touchPoint.state, touchPoint.id, touchPoint.x, touchPoint.y, touchPoint.xAbs, touchPoint.yAbs);
            }
            super.notifyEndTouchEvent(view);
        }
        finally {
            this.curTouchPoints = null;
        }
    }

    public void notifyNextTouchEvent(View view, int n, long l, int n2, int n3, int n4, int n5) {
        View view2 = null;
        if (n == 811) {
            view2 = view;
            this.touchIdToView.put(l, new WeakReference<View>(view));
        } else {
            view2 = (View)this.touchIdToView.get(l).get();
            if (n == 813) {
                this.touchIdToView.remove(l);
            }
        }
        if (view2 == view) {
            this.curTouchPoints.add(new TouchPoint(n, l, n2, n3, n4, n5));
        } else {
            if (view2 != null && view2.isClosed()) {
                view2 = null;
            }
            super.notifyBeginTouchEvent(view2, this.curModifiers, this.curIsDirect, 1);
            super.notifyNextTouchEvent(view2, n, l, n2, n3, n4, n5);
            super.notifyEndTouchEvent(view2);
        }
    }

    private static class TouchPoint {
        final int state;
        final long id;
        final int x;
        final int y;
        final int xAbs;
        final int yAbs;

        TouchPoint(int n, long l, int n2, int n3, int n4, int n5) {
            this.state = n;
            this.id = l;
            this.x = n2;
            this.y = n3;
            this.xAbs = n4;
            this.yAbs = n5;
        }
    }
}

